<?php
/***************************************************************************
 *
 *   IC Post plugin (/inc/plugins/IC_Post.php)
 *	 Author: IcedCoffee
 *   Website: http://eHome.Edu.Vn
 *   
 ***************************************************************************/
 // Disallow direct access to this file for security reasons
if(!defined('IN_MYBB'))
{
	die('Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.');
} 
//Add hook for IC Post
$plugins->add_hook("parse_message", "ParsePost");
$plugins->add_hook("parse_quoted_message", "ParsePostQuote");

function IC_Post_info()
{
	return array(
		"name"		=> "هاك اخفاء المحتوي طبقا للمشاركات ",
		"description"	=> "تستطيع اخفاء المحتوي لمشاركه ما لا يشاهدها الا من لديه عدد مشاركات معين تقوم بتحديده بالكود",
		"website"		=> "http://ehome.edu.vn",
		"author"		=> "IcedCoffee",
		"authorsite"	=> "http://ehome.edu.vn",
		"version"		=> "1.0",
		"guid"		=> "1b55a5295d7473eb2530fdc013756287",
		"compatibility" => "16*"
	);
}
function IC_Post_activate()
{
	global $db, $mybb;

	$IC_Post = array(
		"gid"					=> "NULL",
		"name"				=> "IC Post",
		"title"				=> "هاك اخفاء المحتوي طبقا للمشاركات",
		"description"	=> "اعدادات الهاك.",
		"disporder"		=> "4",
		"isdefault"			=> "no",
	);
	$db->insert_query("settinggroups", $IC_Post);
	$gid = $db->insert_id();
	
	$setting = array(
        "sid"					=> "NULL",
        "name"				=> "post_show",
        "title"				=> "المجموعات المسموح لها",
        "description"	=> "قم باضافة المجموعات التي تستطيع مشاهدة المحتوي بدون اخفاءه",
        "optionscode"	=> "text",
        "value"				=> "",
        "disporder"		=> "1",
        "gid"					=> intval($gid),
        );
    $db->insert_query("settings", $setting);
	
	rebuild_settings();
}
function IC_Post_deactivate()
{
	global $db, $mybb;
	
	$db->delete_query("settings","name IN('post_show')");
	$db->delete_query("settinggroups", "name = 'IC Post'");
	
	rebuild_settings();
}
function ParsePost($message)
{
	global $lang,$mybb;
	
	if(file_exists($lang->path."/".$lang->language."/IC_Post.lang.php"))
	{
		$lang->load("IC_Post");
	}
	else
	{
		$l=$lang->language;
		$lang->set_language();
		$lang->load("IC_Post");
		$lang->set_language($l);
	}
	
	$pattern = "#\[post=(.*?)\](.*?)\[/post\]#si";
	preg_match_all($pattern,$message,$return,PREG_PATTERN_ORDER);
	$postnum = intval($return[1][0]);
	if(!in_array($mybb->user['usergroup'], explode(',', $mybb->settings['post_show'])) && ($mybb->user['postnum'] < $postnum))
		$replace = $lang->IC_Post_notallow;
	else
		$replace = $lang->IC_Post_replace;

	$message = preg_replace($pattern, $replace, $message);

	return $message;
}


function ParsePostQuote($quotepost)
{
	global $lang,$mybb;
	$msg = $quotepost['message'];
	if(file_exists($lang->path."/".$lang->language."/IC_Post.lang.php"))
	{
		$lang->load("IC_Post");
	}
	else
	{
		$l=$lang->language;
		$lang->set_language();
		$lang->load("IC_Post");
		$lang->set_language($l);
	}
	$pattern = "#\[post=(.*?)\](.*?)\[/post\]#si";
	preg_match_all($pattern,$msg,$return,PREG_PATTERN_ORDER);
	$postnum = intval($return[1][0]);
	if (!in_array($mybb->user['usergroup'], explode(',', $mybb->settings['post_show'])) && ($mybb->user['postnum'] < $postnum))
		{
		$replace = $lang->IC_Post_notallow_quote;
		$msg = preg_replace($pattern, $replace, $msg);
		}
	$quotepost['message'] = $msg;
	
	return $quotepost;
}
?>